"use client"
import { t } from 'i18next'
import { useRouter } from 'next/router'
import { useSelector } from 'react-redux'
import Breadcrumb from 'src/components/Common/Breadcrumb'
import dynamic from 'next/dynamic'
const Layout = dynamic(() => import('src/components/Layout/Layout'), { ssr: false })
import { questionsData } from 'src/store/reducers/tempDataSlice'
const ReviewAnswer = dynamic(() => import('src/components/Common/ReviewAnswer'), { ssr: false })

const Index = () => {

  const navigate = useRouter()

  const questions = useSelector(questionsData)

  const handleReviewAnswerBack = () => {
    navigate.push("/quiz-play/true-and-false-play/result")
  }

  return (
    <Layout>
      <Breadcrumb title={t('Daily Quiz')} content="" contentTwo="" />
      <div className='dashboard'>
        <div className='container'>
          <div className='row '>
            <div className='morphisam'>
              <div className='whitebackground'>
                <ReviewAnswer
                  showLevel={false}
                  reviewlevel={false}
                  reportquestions={true}
                  questions={questions}
                  latex={true}
                  goBack={handleReviewAnswerBack}
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </Layout>

  )
}

export default Index