'use client'
import { initializeApp, getApps, getApp } from 'firebase/app'
import firebase from "firebase/compat/app"
import { getAuth } from "firebase/auth";
import { useSelector } from 'react-redux'
import { websettingsData } from 'src/store/reducers/webSettings'
import { getFirestore } from 'firebase/firestore'
import 'firebase/compat/auth';
import 'firebase/compat/firestore';

const FirebaseData = () => {
  const websettingsdata = useSelector(websettingsData)

  const apiKeyData = websettingsdata && websettingsdata?.firebase_api_key
  const authDomainData = websettingsdata && websettingsdata?.firebase_auth_domain
  const databaseURLData = websettingsdata && websettingsdata?.firebase_database_url
  const projectIdData = websettingsdata && websettingsdata?.firebase_project_id
  const storageBucketData = websettingsdata && websettingsdata?.firebase_storage_bucket
  const messagingSenderIdData = websettingsdata && websettingsdata?.firebase_messager_sender_id
  const appIdData = websettingsdata && websettingsdata?.firebase_app_id
  const measurementIdData = websettingsdata && websettingsdata?.firebase_measurement_id

  let firebaseConfig = {
    apiKey: apiKeyData ? apiKeyData : 'xxxxxx',
    authDomain: authDomainData ? authDomainData : 'xxxxx',
    databaseURL: databaseURLData ? databaseURLData : 'xxxxx',
    projectId: projectIdData ? projectIdData : 'xxxxx',
    storageBucket: storageBucketData ? storageBucketData : 'xxxxx',
    messagingSenderId: messagingSenderIdData ? messagingSenderIdData : 'xxxxx',
    appId: appIdData ? appIdData : 'xxxxx',
    measurementId: measurementIdData ? measurementIdData : 'xxxxx'
  }

  // eslint-disable-next-line
  if (!firebase.apps.length) {
    firebase.initializeApp(firebaseConfig)
  }

  const app = initializeApp(firebaseConfig)
  const auth = getAuth(app)
  const firebaseApp = !getApps().length ? initializeApp(firebaseConfig) : getApp()

  const db = getFirestore(app)

  return { auth,db, firebaseApp }
}

export default FirebaseData
